/*****************************************************************************
*                           Freescale Semiconductor                          *
*                                                                            *
*  Project    : AN3815 - MC56F8006 Modular Pixel Matrix                      *
*  Version    : 0.1                                                          *
*  Date       : 16/Apr/2009                                                  *
*  Authors    : Alexandre Dias, Bruno Bastos                                 *
*               Humberto Carvalho, Leonardo Mangiapelo                       *
*               Renato Frias                                                 *
*                                                                            *
* -------------------------------------------------------------------------- *
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR        *
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES  *
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.    *
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT,  *
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES         *
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR         *
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)         *
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,        * 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING      *
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF             *
* THE POSSIBILITY OF SUCH DAMAGE.                                            *
* -------------------------------------------------------------------------- *
*  Description:                                                              *
* This software complements AN3815 - Implementing a Modular High Brightness  *
* RGB LED Network. The aim of the code is to proof the concept described on  *
* the application note document. It also serves as a starting point for      * 
* applications with MC56F8006 and some of its peripherals                    *
* -------------------------------------------------------------------------- *
*                                                                            *
*  File: main.c	                                                             *
*                                                                            *
*    Calls the init functions and program tasks								 * 
*                                                                            *
******************************************************************************/

/************************* Include Files *************************************/

#include "mc56f8006.h"
#include "cpu.h"

/********************************* Defines ***********************************/

#define ADC_GREEN_CHANNEL ADC0_ADCSC1A_ADCH_2 | ADC0_ADCSC1A_ADCH_0
#define ADC_RED_CHANNEL ADC0_ADCSC1A_ADCH_2|ADC0_ADCSC1A_ADCH_1 | ADC0_ADCSC1A_ADCH_0
#define ADC_BLUE_CHANNEL ADC0_ADCSC1A_ADCH_3|ADC0_ADCSC1A_ADCH_0
#define ADC_BUFFER_SIZE 16

/******************************** Type Definitions ***************************/

typedef enum 
{
	READ_GREEN,
	READ_RED,
	READ_BLUE
	
}adc_state_machine;

typedef enum 
{
	ADC_GREEN,
	ADC_RED,
	ADC_BLUE
	
}adc_colors;

/******************************** Prototypes *********************************/

extern void adc_init(void);
extern void adc_isr(void);
extern uint16_t adc_get_color_value(adc_colors);

